IF OBJECT_ID('P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR
	END
GO
--EXEC P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR 1,311626

/*
=======================================================================================
'localizado..........: Linx - Manutencao madrugada (P_ATUALIZA_AGENDA_SUPRIMENTO > P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR_EXEC_ALL)
'Função..............: 
'Objetivo............:  
'Tabelas.............: EST_COMPRADOR_MOVIMENTACAO | EST_COMPRADOR_MOVIMENTACAO_CPL  
'Dt Modificação......: 09/12/2020
'Modificação.........: Foi adicionado indice em 2 tabelas temporarias
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 

*/
CREATE PROCEDURE P_EST_COMPRADOR_MOVIMENTACAO_EXECUTAR @CD_EMP INT=1,@CD_CTR_PROC_DUP INT
WITH ENCRYPTION
AS 
DECLARE @CD_FILIAL INT
DECLARE @CD_PG_CRED INT
DECLARE @CD_PROD INT
DECLARE @VLR_PROD MONEY
DECLARE @VLR_DESCONTO_PROD MONEY
DECLARE @VLR_PROD_LIQUIDO MONEY
DECLARE @VLR_DUPLICATA MONEY
DECLARE @VLR_DESCONTO MONEY
DECLARE @VLR_JUROS MONEY
DECLARE @VLR_DESP_OUTR MONEY
DECLARE @VLR_DEVOLUCAO MONEY
DECLARE @DT_EMIS DATETIME 
DECLARE @DT_VENCTO DATETIME 
DECLARE @CD_CTR INT
DECLARE @CD_COMPRADOR INT
SET NOCOUNT ON

CREATE TABLE #RsRelacaoNotaFiscaisVinculoDoComprador(CD_EMP INT,
													 CD_FILIAL INT,
													 CD_NF INT,
													 NR_DP INT,
													 ANO INT)

--Tag #I001
CREATE INDEX IX_TEMP_RsRelacaoNotaFiscaisVinculoDoComprador ON #RsRelacaoNotaFiscaisVinculoDoComprador (CD_EMP,CD_FILIAL, NR_DP ,ANO ) 

CREATE TABLE #RsContasPagarVariasNotas(CD_EMP INT,
									   CD_FILIAL INT,
									   NR_DP INT,
									   ANO INT)
-- Tag #I001
CREATE INDEX IX_TEMP_#RSCONTASPAGARVARIASNOTAS  ON #RsContasPagarVariasNotas (CD_EMP,CD_FILIAL, NR_DP ,ANO )

CREATE TABLE #RsContasPagarBaixas(CD_EMP INT,
								CD_FILIAL INT,
								CD_PG_CRED INT,
								NR_DP INT,
								ANO INT,
								VLR_DUP_BAIXA MONEY)

CREATE TABLE #RsContasPagar(CD_EMP INT,
							CD_FILIAL INT,
							CD_PG_CRED INT,
							PARC INT,
							CD_NF INT,
							CD_FORN INT,
							DT_EMIS DATETIME,
							DT_VENCTO DATETIME,
							VLR_NF MONEY,
							VLR_DP MONEY,
							VLR_JUROS MONEY,
							VLR_DESC MONEY,
							VLR_DEVOLUCAO MONEY,
							VLR_IMPOSTO MONEY,
							VLR_DESP_OUTR MONEY,
							VLR_PGTO MONEY,
							PERC_PART FLOAT,
							FLAG_VARIAS INT)

CREATE TABLE #RsDupNotasVarias (CD_EMP INT,
						  CD_FILIAL INT,
						  CD_NF INT,
						  NR_DP INT,
						  ANO INT,
						  VLR_NF MONEY)

CREATE TABLE #RsDuplicatasVariais (CD_EMP INT,
						  CD_FILIAL INT,
						  NR_DP INT,
						  ANO INT,
						  VLR_DP MONEY,
						  VLR_DP_BAIXA MONEY,
						  VLR_JUROS MONEY,
						  VLR_DESC MONEY,
						  VLR_DEVOLUCAO MONEY,
						  VLR_IMPOSTO MONEY,
						  VLR_DESP_OUTR MONEY)


INSERT INTO #RsRelacaoNotaFiscaisVinculoDoComprador(CD_EMP,
													 CD_FILIAL,
													 CD_NF,
													 NR_DP,
													 ANO)
SELECT
	DISTINCT rs.CD_EMP,
	rs.CD_FILIAL,
	rs.CD_NF, 
	rs.NR_DP,
	rs.ANO
FROM
	PG_CRED_EST_NF_ENT rs 	INNER JOIN PG_CRED d ON
	rs.CD_EMP = d.CD_EMP AND
	rs.CD_FILIAL = d.CD_FILIAL AND
	rs.NR_DP = d.NR_DP AND
	rs.ANO = d.ANO 
	INNER JOIN PG_CRED_PROC_PENDENCIA p ON
	d.CD_EMP = p.CD_EMP AND
	d.CD_FILIAL = p.CD_FILIAL AND
	d.CD_PG_CRED = p.CD_PG_CRED 
WHERE
	p.CD_CTR = @CD_CTR_PROC_DUP
	   
INSERT INTO #RsContasPagarVariasNotas
SELECT
		PG_CRED_EST_NF_ENT.CD_EMP,
		PG_CRED_EST_NF_ENT.CD_FILIAL,
		PG_CRED_EST_NF_ENT.NR_DP,
		PG_CRED_EST_NF_ENT.ANO
	FROM
		#RsRelacaoNotaFiscaisVinculoDoComprador PG_CRED_EST_NF_ENT 
	GROUP BY
		PG_CRED_EST_NF_ENT.CD_EMP,
		PG_CRED_EST_NF_ENT.CD_FILIAL,
		PG_CRED_EST_NF_ENT.NR_DP,
		PG_CRED_EST_NF_ENT.ANO
	HAVING
		COUNT(NR_DP) > 1

INSERT INTO #RsContasPagarBaixas
	SELECT
		DISTINCT pbx.CD_EMP,
		pbx.CD_FILIAL,
		pbx.CD_PG_CRED,
		pbx.NR_DP,
		pbx.ANO,
		pbx.VLR_DUP_BAIXA
	FROM
		V_PG_CRED_VALOR_BAIXADO pbx INNER JOIN #RsRelacaoNotaFiscaisVinculoDoComprador rs ON
		pbx.CD_EMP= rs.CD_EMP AND
		pbx.CD_FILIAL = rs.CD_FILIAL AND
		pbx.NR_DP = rs.NR_DP AND
		pbx.ANO = rs.ANO
		LEFT OUTER JOIN #RsDupNotasVarias ag ON
		pbx.CD_EMP = ag.CD_EMP AND
		pbx.CD_FILIAL = ag.CD_FILIAL AND
		pbx.NR_DP = ag.NR_DP AND
		pbx.ANO = ag.ANO 	
	WHERE
		ag.ANO IS NULL
		
--Inserindo notas fiscais que possui vinculo com mais de uma duplicata
INSERT INTO #RsDupNotasVarias
SELECT
	E.CD_EMP ,
	E.CD_FILIAL,
	E.CD_NF,
	rs.NR_DP,
	rs.ANO,
	E.VLR_NF
FROM
	#RsRelacaoNotaFiscaisVinculoDoComprador PG_CRED_EST_NF_ENT INNER JOIN #RsContasPagarVariasNotas rs ON
	PG_CRED_EST_NF_ENT.CD_EMP= rs.CD_EMP AND
	PG_CRED_EST_NF_ENT.CD_FILIAL = rs.CD_FILIAL AND
	PG_CRED_EST_NF_ENT.NR_DP = rs.NR_DP AND
	PG_CRED_EST_NF_ENT.ANO = rs.ANO
	INNER JOIN EST_NF_ENT E ON
	PG_CRED_EST_NF_ENT.CD_EMP  = E.CD_EMP AND
	PG_CRED_EST_NF_ENT.CD_FILIAL = E.CD_FILIAL AND
	PG_CRED_EST_NF_ENT.CD_NF = E.CD_NF 

--Inserindo duplicata que possui vinculo com mais uma nota fiscal
INSERT INTO #RsDuplicatasVariais (CD_EMP,
						  CD_FILIAL,
						  NR_DP,
						  ANO,
						  VLR_DP,
						  VLR_DP_BAIXA,
						  VLR_JUROS,
						  VLR_DESC,
						  VLR_DEVOLUCAO,
						  VLR_IMPOSTO,
						  VLR_DESP_OUTR)
SELECT
	p.CD_EMP ,
	p.CD_FILIAL,
	p.NR_DP,
	p.ANO,
	SUM(VLR_DP) AS VLR_DP,
	SUM(VLR_DUP_BAIXA) AS VLR_DUP_BAIXA,
	SUM(VLR_JUROS),
	SUM(VLR_DESC),
	SUM(VLR_DEVOLUCAO),
	SUM(ISNULL(VLR_IMP,0)),
	SUM(VLR_DESP_OUTR)
FROM
	#RsContasPagarVariasNotas rs INNER JOIN PG_CRED p ON
	rs.CD_EMP  = p.CD_EMP AND
	rs.CD_FILIAL = p.CD_FILIAL AND
	rs.NR_DP = p.NR_DP AND
	rs.ANO = p.ANO 
	LEFT OUTER JOIN V_PG_CRED_VALOR_BAIXADO pbx ON
	rs.CD_EMP= pbx.CD_EMP AND
	rs.CD_FILIAL = pbx.CD_FILIAL AND
	rs.NR_DP = pbx.NR_DP AND
	rs.ANO = pbx.ANO
	LEFT OUTER JOIN V_PG_CRED_IMPOSTO im on
	p.CD_EMP = im.CD_EMP AND
	p.CD_FILIAL = im.CD_FILIAL AND
	p.CD_PG_CRED = im.CD_PG_CRED  
GROUP BY
	p.CD_EMP ,
	p.CD_FILIAL,
	p.NR_DP,
	p.ANO

--Gerando o valor da duplicata em relacao as nota fiscais relacionadas
INSERT INTO #RsContasPagar
			(CD_EMP,
			CD_FILIAL,
			CD_PG_CRED,
			PARC,
			CD_NF,
			CD_FORN,
			DT_EMIS,
			DT_VENCTO,
			VLR_NF,
			VLR_DP,
			VLR_JUROS,
			VLR_DESC,
			VLR_DEVOLUCAO,
			VLR_IMPOSTO,
			VLR_DESP_OUTR,
			VLR_PGTO,
			PERC_PART,
			FLAG_VARIAS)
SELECT
	n.CD_EMP,
	n.CD_FILIAL,
	PG_CRED.CD_PG_CRED,
	PG_CRED.PARC,
	n.CD_NF,
	PG_CRED.CD_FORN,
	PG_CRED.DT_EMIS,
	PG_CRED.DT_VENCTO, 
	n.VLR_NF,
	CASE WHEN d.VLR_DP>0 THEN
		ROUND(PG_CRED.VLR_DP * (CAST(n.VLR_NF AS FLOAT)/d.VLR_DP),2) 
	ELSE
		0
	END  AS VLR_DP,
	CASE WHEN PG_CRED.VLR_JUROS>0 THEN
		ROUND(PG_CRED.VLR_JUROS * (CAST(n.VLR_NF AS FLOAT)/d.VLR_DP),2) 
	ELSE
		0
	END  AS VLR_JUROS,
	CASE WHEN d.VLR_DESC>0 THEN
		ROUND(PG_CRED.VLR_DESC * (CAST(n.VLR_NF AS FLOAT)/d.VLR_DP),2) 
	ELSE
		0
	END  AS VLR_DESC,
	CASE WHEN PG_CRED.VLR_DEVOLUCAO>0 THEN
		ROUND(PG_CRED.VLR_DEVOLUCAO * (CAST(n.VLR_NF AS FLOAT)/d.VLR_DP),2)
	ELSE
		0
	END  AS VLR_DEVOLUCAO,
	CASE WHEN im.VLR_IMP>0 THEN
		ROUND(ISNULL(im.VLR_IMP,0) * (CAST(n.VLR_NF AS FLOAT)/d.VLR_DP),2) 
	ELSE
		0
	END AS VLR_IMP,
	CASE WHEN PG_CRED.VLR_DESP_OUTR>0 THEN
		ROUND(PG_CRED.VLR_DESP_OUTR * (CAST(n.VLR_NF AS FLOAT)/d.VLR_DP),2) 
	ELSE
		0
	END AS VLR_DESP_OUTR,
	CASE WHEN D.VLR_DP_BAIXA>0 THEN
		ROUND(ISNULL(pbx.VLR_DUP_BAIXA,0) * (CAST(n.VLR_NF AS FLOAT)/D.VLR_DP),2) 
	ELSE
		0
	END AS VLR_DP_BAIXA,
	CASE WHEN D.VLR_DP_BAIXA > 0 THEN
		(CAST(n.VLR_NF AS FLOAT)/D.VLR_DP_BAIXA)	
	ELSE
		0
	END AS VLR_DP_BAIXA,
	1 AS FLAG_VARIAS
FROM
	#RsDupNotasVarias n INNER JOIN #RsDuplicatasVariais d ON
	n.CD_EMP = d.CD_EMP AND
	n.CD_FILIAL = d.CD_FILIAL AND
	n.NR_DP = d.NR_DP AND
	n.ANO = d.ANO
	INNER JOIN PG_CRED ON
	n.CD_EMP = PG_CRED.CD_EMP AND
	n.CD_FILIAL = PG_CRED.CD_FILIAL AND
	n.NR_DP = PG_CRED.NR_DP AND
	n.ANO = PG_CRED.ANO
	LEFT OUTER JOIN V_PG_CRED_IMPOSTO im on
	PG_CRED.CD_EMP = im.CD_EMP AND
	PG_CRED.CD_FILIAL = im.CD_FILIAL AND
	PG_CRED.CD_PG_CRED = im.CD_PG_CRED  
	LEFT OUTER JOIN #RsContasPagarBaixas pbx ON
	PG_CRED.CD_EMP  = pbx.CD_EMP AND
	PG_CRED.CD_FILIAL = pbx.CD_FILIAL AND
	PG_CRED.NR_DP = pbx.NR_DP AND
	PG_CRED.ANO = pbx.ANO 

--Unica Nota Fiscal relacionada com a duplicata
INSERT INTO #RsContasPagar
SELECT
	PG_CRED.CD_EMP,
	PG_CRED.CD_FILIAL,
	PG_CRED.CD_PG_CRED,
	PG_CRED.PARC,
	EST_NF_ENT.CD_NF,
	PG_CRED.CD_FORN, 
	PG_CRED.DT_EMIS,
	PG_CRED.DT_VENCTO, 
	EST_NF_ENT.VLR_NF,
	PG_CRED.VLR_DP,
	PG_CRED.VLR_JUROS,
	PG_CRED.VLR_DESC,
	PG_CRED.VLR_DEVOLUCAO,
	ISNULL(im.VLR_IMP,0),
	ISNULL(PG_CRED.VLR_DESP_OUTR,0),
	ISNULL(pbx.VLR_DUP_BAIXA,0) AS VLR_DP_BAIXA,
	100.00,
	0 AS FLAG_VARIAS
FROM
	PG_CRED INNER JOIN #RsRelacaoNotaFiscaisVinculoDoComprador ep ON
	PG_CRED.CD_EMP = ep.CD_EMP AND
	PG_CRED.CD_FILIAL = ep.CD_FILIAL AND
	PG_CRED.NR_DP = ep.NR_DP AND
	PG_CRED.ANO = ep.ANO 
	INNER JOIN EST_NF_ENT ON
	ep.CD_EMP = EST_NF_ENT.CD_EMP AND
	ep.CD_FILIAL = EST_NF_ENT.CD_FILIAL AND
	ep.CD_NF = EST_NF_ENT.CD_NF 
	LEFT OUTER JOIN #RsDupNotasVarias ag ON
	PG_CRED.CD_EMP = ag.CD_EMP AND
	PG_CRED.CD_FILIAL = ag.CD_FILIAL AND
	PG_CRED.NR_DP = ag.NR_DP AND
	PG_CRED.ANO = ag.ANO 
	LEFT OUTER JOIN V_PG_CRED_IMPOSTO im on
	PG_CRED.CD_EMP = im.CD_EMP AND
	PG_CRED.CD_FILIAL = im.CD_FILIAL AND
	PG_CRED.CD_PG_CRED = im.CD_PG_CRED  
	LEFT OUTER JOIN #RsContasPagarBaixas pbx ON
	PG_CRED.CD_EMP  = pbx.CD_EMP AND
	PG_CRED.CD_FILIAL = pbx.CD_FILIAL AND
	PG_CRED.CD_PG_CRED   = pbx.CD_PG_CRED  
WHERE
	ag.NR_DP IS NULL
	
DELETE 
	d 
FROM
	EST_COMPRADOR_MOVIMENTACAO_CPL d INNER JOIN #RsContasPagar P ON
	d.CD_EMP = p.CD_EMP AND
	d.CD_FILIAL = p.CD_FILIAL AND
	d.CD_PG_CRED = p.CD_PG_CRED

DECLARE CCompradorCargaAplicar CURSOR FAST_FORWARD FOR
		SELECT
			distinct ITCP.CD_COMPRADOR
		FROM
			EST_NF_ENT_IT_COMPRADOR ITCP INNER JOIN #RsContasPagar PG ON
			ITCP.CD_EMP = PG.CD_EMP AND
			ITCP.CD_FILIAL = PG.CD_FILIAL AND
			ITCP.CD_NF = PG.CD_NF  

OPEN CCompradorCargaAplicar;
FETCH NEXT FROM CCompradorCargaAplicar INTO @CD_COMPRADOR;

WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT '  Comprador ' + CONVERT(VARCHAR(5), @CD_COMPRADOR) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';

		SET @CD_CTR = ISNULL((SELECT
								CD_CTR
							  FROM 
								EST_COMPRADOR_MOVIMENTACAO 
							  WHERE 
								CD_COMPRADOR = @CD_COMPRADOR),0)
		IF @CD_CTR=0
			BEGIN
				INSERT INTO EST_COMPRADOR_MOVIMENTACAO
				(CD_EMP,
				CD_COMPRADOR,
				DT_CAD)
				SELECT
					@CD_EMP,
					@CD_COMPRADOR,
					GETDATE()

				SET @CD_CTR = (SELECT IDENT_CURRENT('EST_COMPRADOR_MOVIMENTACAO'))
			END

		INSERT INTO EST_COMPRADOR_MOVIMENTACAO_CPL
		(
		CD_CTR, 
		CD_EMP,
		CD_FILIAL,
		CD_PG_CRED,
		CD_PROD,
		VLR_DP,
		VLR_DESC,
		VLR_JUROS,
		VLR_DESP_OUTR,
		VLR_DEVOLUCAO,
		DT_EMIS,
		DT_VENCTO,
		CD_FORN,
		CD_TP_FORN,
		VLR_IMP,
		TIPO_TRANSACAO, 
		VLR_DUP_PGTO
		)
		SELECT
			@CD_CTR,	
			IT.CD_EMP,
			IT.CD_FILIAL,
			PG.CD_PG_CRED,
			IT.CD_PROD,
			SUM(ROUND((CAST((IT.VLR_TOT_IT - (IT.VLR_DESC + ISNULL(IT.VLR_ICMS_DESONERADO,0))) + IT.VLR_ICMS_SUBS + ISNULL(IT.VLR_OUTRAS_DESPESAS,0) + 
			ISNULL(IT.VLR_IPI,0) + ISNULL(IT.VLR_FECOP_ST,0) + ISNULL(IT.VLR_PROD_FRETE,0)  AS FLOAT) / PG.VLR_NF) * PG.VLR_DP,2)) AS VLR_DUPLICATA,
			SUM(CASE WHEN PG.VLR_DESC > 0 THEN
				ROUND((CAST((IT.VLR_TOT_IT - (IT.VLR_DESC + ISNULL(IT.VLR_ICMS_DESONERADO,0))) + IT.VLR_ICMS_SUBS + ISNULL(IT.VLR_OUTRAS_DESPESAS,0) + ISNULL(IT.VLR_IPI,0) + ISNULL(IT.VLR_FECOP_ST,0) + ISNULL(VLR_PROD_FRETE,0)  AS FLOAT) / PG.VLR_NF) * PG.VLR_DESC,2)
			ELSE
				0
			END) AS VLR_DESCONTO,	
			SUM(CASE WHEN PG.VLR_JUROS > 0 THEN
				ROUND((CAST((IT.VLR_TOT_IT - (IT.VLR_DESC + ISNULL(IT.VLR_ICMS_DESONERADO,0))) + IT.VLR_ICMS_SUBS + ISNULL(IT.VLR_OUTRAS_DESPESAS,0) + ISNULL(IT.VLR_IPI,0) + ISNULL(IT.VLR_FECOP_ST,0) + ISNULL(VLR_PROD_FRETE,0)  AS FLOAT) / PG.VLR_NF) * PG.VLR_JUROS,2)
			ELSE
				0
			END) AS VLR_JUROS,	
			SUM(CASE WHEN PG.VLR_DESP_OUTR > 0 THEN
				ROUND((CAST((IT.VLR_TOT_IT - (IT.VLR_DESC + ISNULL(IT.VLR_ICMS_DESONERADO,0))) + IT.VLR_ICMS_SUBS + ISNULL(IT.VLR_OUTRAS_DESPESAS,0) + ISNULL(IT.VLR_IPI,0) + ISNULL(IT.VLR_FECOP_ST,0) + ISNULL(VLR_PROD_FRETE,0)  AS FLOAT) / PG.VLR_NF) * PG.VLR_DESP_OUTR,2)
			ELSE
				0
			END) AS VLR_DESP_OUTR,	
			SUM(CASE WHEN PG.VLR_DEVOLUCAO > 0 THEN
				ROUND((CAST((IT.VLR_TOT_IT - (IT.VLR_DESC + ISNULL(IT.VLR_ICMS_DESONERADO,0))) + IT.VLR_ICMS_SUBS + ISNULL(IT.VLR_OUTRAS_DESPESAS,0) + ISNULL(IT.VLR_IPI,0) + ISNULL(IT.VLR_FECOP_ST,0) + ISNULL(VLR_PROD_FRETE,0)  AS FLOAT) / PG.VLR_NF) * PG.VLR_DEVOLUCAO,2)
			ELSE
				0
			END) AS VLR_DEVOLUCAO,
			PG.DT_EMIS,
			PG.DT_VENCTO,
			PG.CD_FORN,
			PG_TP_FORN.CD_TP_FORN,
			SUM(CASE WHEN isnull(PG.VLR_IMPOSTO,0) > 0 THEN
				ROUND((CAST((IT.VLR_TOT_IT - (IT.VLR_DESC + ISNULL(IT.VLR_ICMS_DESONERADO,0))) + IT.VLR_ICMS_SUBS + ISNULL(IT.VLR_OUTRAS_DESPESAS,0) + ISNULL(IT.VLR_IPI,0) + ISNULL(IT.VLR_FECOP_ST,0) + ISNULL(VLR_PROD_FRETE,0)  AS FLOAT) / PG.VLR_NF) * PG.VLR_IMPOSTO,2)
			ELSE
				0
			END) AS VLR_IMP,
			0 AS TIPO_TRANSACAO,
			SUM(CASE WHEN isnull(PG.VLR_PGTO,0) > 0 THEN
				ROUND((CAST((IT.VLR_TOT_IT - (IT.VLR_DESC + ISNULL(IT.VLR_ICMS_DESONERADO,0))) + IT.VLR_ICMS_SUBS + ISNULL(IT.VLR_OUTRAS_DESPESAS,0) + ISNULL(IT.VLR_IPI,0) + ISNULL(IT.VLR_FECOP_ST,0) + ISNULL(VLR_PROD_FRETE,0)  AS FLOAT) / PG.VLR_NF) * PG.VLR_PGTO,2)
			ELSE
				0
			END) AS VLR_PGTO
		FROM
			EST_NF_ENT_IT IT INNER JOIN EST_NF_ENT_IT_COMPRADOR ITCP ON
			IT.CD_EMP = ITCP.CD_EMP AND
			IT.CD_FILIAL = ITCP.CD_FILIAL AND
			IT.CD_NF = ITCP.CD_NF AND 
			IT.CD_PROD = ITCP.CD_PROD 
			INNER JOIN #RsContasPagar PG ON
			IT.CD_EMP = PG.CD_EMP AND
			IT.CD_FILIAL = PG.CD_FILIAL AND
			IT.CD_NF = PG.CD_NF  
			INNER JOIN PG_FORN ON
			PG.CD_EMP = PG_FORN.CD_EMP AND
			PG.CD_FORN = PG_FORN.CD_FORN 
			INNER JOIN PG_TP_FORN ON
			PG_FORN.CD_TP_FORN = PG_TP_FORN.CD_TP_FORN 
		WHERE
			ITCP.CD_COMPRADOR = @CD_COMPRADOR
		  AND PG.VLR_NF > 0
		GROUP BY
			IT.CD_EMP,
			IT.CD_FILIAL,
			PG.CD_PG_CRED,
			IT.CD_PROD,
			PG.DT_EMIS,
			PG.DT_VENCTO,
			PG.CD_FORN,
			PG_TP_FORN.CD_TP_FORN,
			PG.PARC,
			ITCP.CD_COMPRADOR 
		FETCH NEXT FROM CCompradorCargaAplicar INTO @CD_COMPRADOR ;
	END ;

CLOSE CCompradorCargaAplicar ;
DEALLOCATE CCompradorCargaAplicar ;

DROP TABLE #RsContasPagar
DROP TABLE #RsDuplicatasVariais
DROP TABLE #RsDupNotasVarias
DROP TABLE #RsContasPagarVariasNotas
DROP TABLE #RsRelacaoNotaFiscaisVinculoDoComprador
DROP TABLE #RsContasPagarBaixas